﻿/**************************************************************************/
/*　　　　　　　　　文字の囲み罫を作成（文字の罫巻き）　　　　　　　　　　*/
/*　　　　　　　　　　　　　　　　　　　　　　　　　　　　　by　お～まち　*/
/*　　　　　　　　　　　　　　　　　　　　　　 2025.11.10　Version 2.1.0　*/
/**************************************************************************/

if (app.scriptPreferences.userInteractionLevel != 1699311169) {
	app.scriptPreferences.userInteractionLevel = 1699311169; //UserInteractionLevels.interactWithAll
}
if (app.windows.length < 1) {
	alert("ドキュメントを開き、囲み罫を作成する文字列を選択してください");
	exit();
}
if (app.selection.length != 1){
	alert("囲み罫を作成する文字列を選択してください");
	exit();
}
switch (app.selection[0].constructor.name){
	case "Story":
	case "Text":
	case "TextStyleRange":
	case "TextColumn":
	case "Paragraph":
	case "Line":
	case "Word":
	case "Character":
		app.doScript(make_stroke, ScriptLanguage.JAVASCRIPT, app.selection[0], UndoModes.FAST_ENTIRE_SCRIPT);
		//make_stroke(app.selection[0]);
		break;
	default:
		alert("囲み罫を作成する文字列を選択してください");
}

function make_stroke (selstr) {
	var ver = parseInt(app.version);
	var doc = app.activeDocument;
	var ch1 = selstr.characters[0];
	var ch2 = selstr.characters[-1];
	//ダイアログの準備
	var sw = [];
	var sj = [];
	for (var i = 0 ; i < doc.swatches.length ; i++) {
		sw[i] = doc.swatches[i].name;
		switch (sw[i]) {
			case "None"		 : sj[i] = "[なし]"; break;
			case "Paper"		: sj[i] = "[紙色]"; break;
			case "Black"		: sj[i] = "[黒]"; var sws = i; break;
			case "Registration" : sj[i] = "[レジストレーション]"; break;
			default: sj[i] = sw[i];
		}
	}
	var ss = [];
	for (i = 0 ; i < doc.strokeStyles.length ; i++) {
		ss[i] = doc.strokeStyles[i].name;
		if (ss[i] == "ベタ") var sss = i;
	}
	switch (doc.viewPreferences.strokeMeasurementUnits) {
		case 2053729891 : uns = 1; break; //インチ
		case 2053991795 : uns = 2; break; //ミリメートル
		case 2053336435 : uns = 3; break; //センチメートル
		case 1516790048 : uns = 4; break; //歯
		case 1514238068 : uns = 5; break; //アメリカ式ポイント
		default : uns = 0;
	}
	un = ["ポイント", "インチ", "ミリメートル", "センチメートル", "歯", "アメリカ式ポイント"];
	ux = [1, 72, 2.83465, 28.3465, 0.7087, 0.996];
	ak = ["なし", "細いスペース", "1/6スペース", "1/4スペース", "1/3スペース", "ENスペース", "全角"];
	ax = ["\u0003", "\u2009", "\u2006", "\u2005", "\u2004", "\u2002", "　"];
	//ダイアログ作成
	dlg = app.dialogs.add({name:"囲み罫の設定"});
	dlc = dlg.dialogColumns.add();
	with(dlc.dialogRows.add()){ //1行目
		staticTexts.add({staticLabel:"線幅："});
		dkwv = realEditboxes.add({minWidth:80, minimumValue:0.004, maximumValue:100, editValue:0.12});
		dkwu = dropdowns.add({stringList:un, selectedIndex:uns});
	}
	with(dlc.dialogRows.add()){ //2行目
		staticTexts.add({staticLabel:"線種："});
		dkss = dropdowns.add({stringList:ss, selectedIndex:sss});
	}
	with(dlc.dialogRows.add()){ //3行目
		staticTexts.add({staticLabel:"線の色："});
		dksw = dropdowns.add({stringList:sj, selectedIndex:sws});
	}
	with(dlc.dialogRows.add()){ //4行目
		staticTexts.add({staticLabel:"行送り方向オフセット："});
		dkvv = realEditboxes.add({minWidth:80, editValue:0});
		dkvu = dropdowns.add({stringList:un, selectedIndex:uns});
	}
	with(dlc.dialogRows.add()){ //5行目
		staticTexts.add({staticLabel:"字送り方向内側のアキ："});
		dkai = realEditboxes.add({minWidth:80, editValue:0.33});
		staticTexts.add({staticLabel:"em"});
	}
	with(dlc.dialogRows.add()){ //6行目
		staticTexts.add({staticLabel:"字送り方向外側のアキ："});
		dkao = dropdowns.add({stringList:ak, selectedIndex:4});
	}
	if (dlg.show() == false){
		dlg.destroy(); //ダイアログを解放
		return;
	}
	k_wei = dkwv.editValue * ux[dkwu.selectedIndex]; //線幅
	sss = ss[dkss.selectedIndex];
	sws = sw[dksw.selectedIndex];
	k_ofs = dkvv.editValue * ux[dkvu.selectedIndex]; //上下のオフセット
	k_aki = dkai.editValue;
	ksp = ax[dkao.selectedIndex];
	dlg.destroy(); //ダイアログを解放
	
	app.scriptPreferences.measurementUnit = 2054188905; //MeasurementUnits.points
	ost = selstr.parentStory;
	if (ost.storyPreferences.storyOrientation == 1752134266) { //StoryHorizontalOrVertical.horizontal
		tateyoko = "yoko";
	} else {
		tateyoko = "tate";
	}
	fnt = ch1.appliedFont;
	bl = fontbaseline(fnt, doc);
	if (bl == 0) {
		alert("フォントのベースラインの値取得に失敗しました\r" +
			"プログラムを終了します");
		exit();
	}
	
	//最大の文字サイズを取得
	fs = 0;
	for (i = 0 ; i < selstr.characters.length ; i++ ) {
		if (selstr.characters[i].pointSize > fs) {
			fs = selstr.characters[i].pointSize;
		}
	}
	
	//下線を設定
	selstr.underlineWeight = k_wei;
	selstr.underlineType = sss;
	selstr.underlineColor = sws;
	selstr.underlineOffset = fs * (1 - bl) + k_ofs;
	selstr.underline = true;
	//打ち消し線を設定
	selstr.strikeThroughWeight = k_wei;
	selstr.strikeThroughType = sss;
	selstr.strikeThroughColor = sws;
	selstr.strikeThroughOffset = fs * bl + k_ofs;
	selstr.strikeThru = true;
	//前後の空き
	ch1.leadingAki = k_aki;
	ch2.trailingAki = k_aki;
	ch1.noBreak = true;
	ost.insertionPoints[ch1.index + 1].leadingAki = 0;
	//ストーリーの最後でも段落末でもなければ指定された幅の空白を挿入
	if (ost.length - 1 == ch2.index){
		ost.insertionPoints[ch2.index + 1].contents = "\u0003";
	} else if(ost.characters[ch2.index + 1].contents == "\u000d"){
		ost.insertionPoints[ch2.index + 1].contents = "\u0003";
	} else {
		ost.insertionPoints[ch2.index + 1].contents = ksp;
	}
	ost.characters[ch2.index + 1].underline = false;
	ost.characters[ch2.index + 1].strikeThru = false;
	ost.characters[ch2.index + 1].trailingAki = 0;
	//ストーリーの先頭でも段落先頭でもなければ指定された幅の空白を挿入
	if (ch1.index == 0){
		ost.insertionPoints[ch1.index].contents = "\u0003";
	} else if(ost.characters[ch1.index - 1].contents == "\u000d"){
		ost.insertionPoints[ch1.index].contents = "\u0003";
	} else {
		ost.insertionPoints[ch1.index].contents = ksp;
	}
	//アンカーオブジェクトの挿入（後ろ）
	if (ver < 6) {
		var gl = ost.insertionPoints[ch2.index + 2].graphicLines.add();
	} else {
		var gl = ost.insertionPoints[ch2.index + 1].graphicLines.add();
	}
	if (ver == 4){ //CS2  これがないと何故かエラー
		myzoom = app.activeWindow.zoomPercentage;
		app.activeWindow.zoomPercentage = myzoom;
	}
	if (tateyoko == "yoko") {
		gl.geometricBounds = [0, 0, fs + 2 * k_ofs + k_wei, 0];
	} else {
		gl.geometricBounds = [0, 0, 0, fs + 2 * k_ofs + k_wei];
	}
	gl.strokeWeight = k_wei;
	gl.strokeType = sss;
	gl.strokeColor = sws;
	with (gl.anchoredObjectSettings) {
		anchoredPosition = 1097814113; //AnchorPosition.anchored
		if (tateyoko == "yoko") {
			anchorPoint = 1095660131; //AnchorPoint.rightCenterAnchor
		} else {
			anchorPoint = 1095656035; //AnchorPoint.bottomCenterAnchor
		}
		horizontalAlignment = 1919379572; //HorizontalAlignment.rightAlign
		verticalAlignment = 1667591796; //VerticalAlignment.centerAlign
		horizontalReferencePoint = 1095786862; //AnchoredRelativeTo.anchorLocationアンカーマーカー
		verticalReferencePoint = 1096180321; //VerticallyRelativeTo.lineBaseline
		anchorYoffset = -0.5 * fs; //「仮想ボディの中央」がないための策
		pinPosition = false;
		lockPosition = true;
	}
	if (ver == 5) { //CS3で分離禁則設定
		ost.characters[ch2.index+1].noBreak = true;
		ost.characters[ch2.index+2].noBreak = true;
	} else if (ver > 5.9) { //CS4以降で分離禁則設定
		ost.characters[ch2.index+0].noBreak = true;
		ost.characters[ch2.index+1].noBreak = true;
	}
	//アンカーオブジェクトの挿入（前）
	if (ver < 6) {
		var gl = ost.insertionPoints[ch1.index + 1].graphicLines.add();
	} else {
		var gl = ost.insertionPoints[ch1.index + 0].graphicLines.add();
	}
	if (ver == 4) { //CS2これがないと何故かエラー
		myzoom = app.activeWindow.zoomPercentage;
		app.activeWindow.zoomPercentage = myzoom;
	}
	if (tateyoko == "yoko") {
		gl.geometricBounds = [0, 0, fs + 2 * k_ofs + k_wei, 0];
	} else {
		gl.geometricBounds = [0, 0, 0, fs + 2 * k_ofs + k_wei];
	}
	gl.strokeWeight = k_wei;
	gl.strokeType = sss;
	gl.strokeColor = sws;
	with (gl.anchoredObjectSettings) {
		anchoredPosition = 1097814113;
		if (tateyoko == "yoko") {
			anchorPoint = 1095658595; //AnchorPoint.leftCenterAnchor
		} else {
			anchorPoint = 1095660643; //AnchorPoint.topCenterAnchor
		}
		horizontalAlignment = 1818584692; //HorizontalAlignment.leftAlign
		verticalAlignment = 1667591796;
		horizontalReferencePoint = 1095786862;
		verticalReferencePoint = 1096180321;
		anchorYoffset = -0.5 * fs;
		pinPosition = false;
		lockPosition = true;
	}
	if (ver < 6) {
		ost.characters[ch1.index + 1].noBreak = true;
	} else {
		ost.characters[ch1.index + 0].noBreak = true;
	}
}
//フォントのベースラインを取得する関数
function fontbaseline ( myFont, doc ) {
	txf = doc.textFrames.add();
    txf.strokeWeight = 0;
    txf.geometricBounds = [0, 0, 100, 200];
	with (txf.textFramePreferences) {
		textColumnCount = 1;
		insetSpacing = [0, 0, 0, 0];
		firstBaselineOffset = 1296386159; //FirstBaseline.EmboxHeight
		ignoreWrap = true;
	}
	with (txf.parentStory) {
		storyPreferences.frameType = 1417176692; //FrameTypes.textFrameType
		storyPreferences.storyOrientation = 1752134266; //StoryHorizontalOrVertical.horizontal
		gridAlignment = 1852796517; //GridAlignment.NONE
		baselineShift = 0;
		gridGyoudori = 0;
		leftIndent = 0;
		rightIndent = 0;
		firstLineIndent = 0;
		lastLineIndent = 0;
		verticalScale = 100;
		horizontalScale = 100;
		contents = "あ";
		appliedFont = myFont;
		pointSize = 100;
	}
	// InDesignバグ回避：線幅0のオブジェクトにstrokeWeight=0を指定すると
	// 線幅が1pt（日本語版は0.1mm）になる　CC2018以降か
	if (txf.strokeWeight != 0) txf.strokeWeight = 0;
	if (txf.overflows) {
		txf.remove();
		return 0;
	}
	blp = txf.lines[0].baseline / 100;
	txf.remove();
	return blp;
}
